/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.util.Util;

public class GuiNpcFollower
extends GuiContainerNPCInterface
implements IGuiData {
    private final RoleFollower role;
    private EntityNPCInterface displayNPC;

    public GuiNpcFollower(EntityNPCInterface npc, ContainerNPCFollowerHire container) {
        super(npc, (Container)container);
        this.field_147000_g = 224;
        this.closeOnEsc = true;
        this.setBackground("follower.png");
        this.role = (RoleFollower)npc.advanced.roleInterface;
        NoppesUtilPlayer.sendData(EnumPlayerPacket.RoleGet, new Object[0]);
        NBTTagCompound npcNbt = new NBTTagCompound();
        npc.func_70014_b(npcNbt);
        npc.func_70039_c(npcNbt);
        Entity e = EntityList.func_75615_a((NBTTagCompound)npcNbt, (World)this.field_146297_k.field_71441_e);
        if (e instanceof EntityNPCInterface) {
            this.displayNPC = (EntityNPCInterface)e;
            this.displayNPC.display.setShowName(1);
            MarkData.get((EntityLivingBase)this.displayNPC).marks.clear();
            this.displayNPC.field_70177_z = npc.field_70177_z;
            this.displayNPC.field_70125_A = npc.field_70125_A;
            this.displayNPC.ais.orientation = npc.ais.orientation;
            this.displayNPC.ais.setStandingType(1);
            if (npc instanceof EntityCustomNpc && this.displayNPC instanceof EntityCustomNpc && ((EntityCustomNpc)npc).modelData != null && ((EntityCustomNpc)this.displayNPC).modelData != null) {
                ((EntityCustomNpc)this.displayNPC).modelData.entity = ((EntityCustomNpc)npc).modelData.entity;
            }
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() < 4) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.FollowerExtend, button.getID());
        } else {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.FollowerState, button.getID() - 5);
            if (button.getID() == 6) {
                this.close();
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int size;
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int index = 0;
        if (!this.role.infiniteDays) {
            for (int slot = 0; slot < this.role.rentalItems.items.size(); ++slot) {
                ItemStack itemstack = (ItemStack)this.role.rentalItems.items.get(slot);
                if (NoppesUtilServer.IsItemStackNull(itemstack)) continue;
                int days = 1;
                if (this.role.rates.containsKey(slot)) {
                    days = this.role.rates.get(slot);
                }
                int yOffset = index * 16;
                int x = this.field_147003_i + 68;
                int y = this.field_147009_r + yOffset + 4;
                GlStateManager.func_179091_B();
                RenderHelper.func_74520_c();
                this.field_146296_j.func_180450_b(itemstack, x + 11, y);
                this.field_146296_j.func_175030_a(this.field_146289_q, itemstack, x + 11, y);
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                String daysS = days + " " + (days == 1 ? new TextComponentTranslation("follower.day", new Object[0]).func_150254_d() : new TextComponentTranslation("follower.days", new Object[0]).func_150254_d());
                this.field_146289_q.func_78276_b(" = " + daysS, x + 27, y + 4, CustomNpcResourceListener.DefaultTextColor);
                if (this.func_146978_c(x - this.field_147003_i + 11, y - this.field_147009_r, 16, 16, mouseX, mouseY)) {
                    this.func_146285_a(itemstack, mouseX, mouseY);
                }
                ++index;
            }
        }
        if ((size = this.role.inventory.func_70302_i_()) > 0) {
            int s = size == 2 || size == 4 ? 2 : 3;
            GlStateManager.func_179094_E();
            this.field_146297_k.func_110434_K().func_110577_a(this.background);
            GlStateManager.func_179109_b((float)(this.field_147003_i + 172), (float)(this.field_147009_r + 135), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(3, 0, 118, 0, 58, 1);
            this.func_73729_b(2, 1, 117, 1, 59, 1);
            this.func_73729_b(1, 2, 116, 2, 60, 1);
            this.func_73729_b(0, 3, 115, 3, 61, 82);
            this.func_73729_b(0, 85, 115, 220, 61, 4);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_147003_i + 173), (float)(this.field_147009_r + 141), (float)0.0f);
            this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
            for (int slotId = 0; slotId < size; ++slotId) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(slotId % s * 18, slotId / s * 18, 0, 0, 18, 18);
            }
            GlStateManager.func_179121_F();
        }
        if (this.role.rates.containsKey(3) && this.role.rentalMoney > 0) {
            int days = this.role.rates.get(3);
            String daysS = days + " " + (days == 1 ? new TextComponentTranslation("follower.day", new Object[0]).func_150254_d() : new TextComponentTranslation("follower.days", new Object[0]).func_150254_d());
            String money = Util.instance.getTextReducedNumber(this.role.rentalMoney, true, true, false) + " " + CustomNpcs.displayCurrencies;
            this.field_146289_q.func_78276_b(money + " = " + daysS, this.field_147003_i + 80, this.field_147009_r + 56, CustomNpcResourceListener.DefaultTextColor);
        }
        if (this.displayNPC != null) {
            this.drawNpc((Entity)this.displayNPC, 33, 131, 1.0f, 0, 0, 1);
        } else {
            this.drawNpc(33, 131);
        }
    }

    protected void func_146979_b(int par1, int par2) {
        long time = (System.currentTimeMillis() - this.role.hiredTime) / 50L;
        this.field_146289_q.func_78276_b(new TextComponentTranslation("follower.health", new Object[0]).func_150254_d() + ": " + this.npc.func_110143_aJ() + "/" + this.npc.func_110138_aP(), 62, 70, CustomNpcResourceListener.DefaultTextColor);
        if (!this.role.infiniteDays) {
            this.field_146289_q.func_78276_b(new TextComponentTranslation("follower.daysleft", new Object[0]).func_150254_d() + " " + Util.instance.ticksToElapsedTime((long)this.role.getDays() * 28800L - time, false, true, false), 62, 82, CustomNpcResourceListener.DefaultTextColor);
        }
        this.field_146289_q.func_78276_b(new TextComponentTranslation("follower.lastday", new Object[0]).func_150254_d() + ": " + Util.instance.ticksToElapsedTime(time, false, true, false), 62, 94, CustomNpcResourceListener.DefaultTextColor);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < 3; ++i) {
            if (this.getButton(i) == null) continue;
            this.getButton(i).setEnabled(this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d || Util.instance.canRemoveItems((NonNullList<ItemStack>)this.field_146297_k.field_71439_g.field_71071_by.field_70462_a, this.role.rentalItems.func_70301_a(i), false, false));
        }
        if (this.getButton(3) != null) {
            this.getButton(3).setEnabled(this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d || ClientProxy.playerData.game.getMoney() >= (long)this.role.rentalMoney);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        GuiNpcButton button;
        super.func_73866_w_();
        int x = this.field_147003_i + 12;
        int y = this.field_147009_r - 11;
        if (!this.role.infiniteDays) {
            for (int i = 0; i < 3; ++i) {
                if (this.role.rentalItems.func_70301_a(i).func_190926_b()) continue;
                button = new GuiNpcButton(i, x, y += 16, 60, 13, new TextComponentTranslation("follower.extend", new Object[0]).func_150254_d());
                button.setHoverText("follower.hover.extend", new Object[0]);
                this.addButton(button);
            }
        }
        if (this.role.rates.containsKey(3) && this.role.rentalMoney > 0) {
            button = new GuiNpcButton(3, x, this.field_147009_r + 53, 60, 13, new TextComponentTranslation("follower.extend", new Object[0]).func_150254_d());
            button.setHoverText("follower.hover.extend", new Object[0]);
            this.addButton(button);
        }
        y = this.field_147009_r + 105;
        button = new GuiNpcButton(5, x += 52, y, 50, 14, new String[]{new TextComponentTranslation("follower.waiting", new Object[0]).func_150254_d(), new TextComponentTranslation("follower.following", new Object[0]).func_150254_d()}, this.role.isFollowing ? 0 : 1);
        button.setHoverText("follower.hover.move", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(6, x + 54, y, 50, 14, new TextComponentTranslation("follower.fire", new Object[0]).func_150254_d());
        button.setHoverText("follower.hover.fire", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.npc.advanced.roleInterface.load(compound);
        this.func_73866_w_();
    }
}

